#ifndef _lf_lag_h
#define _lf_lag_h
#ifndef MCP
#include <string.h>
#endif
/*
 * Link aggregation structures and definitions
 */

#define LF_LAG_HASH_TABLE_SIZE 1024

#define lf_lag_match(L1, L2) (memcmp((L1), (L2), LF_LAG_ID_LEN)==0)
#define lf_lag_copy(D, S) memcpy((D), (S), LF_LAG_ID_LEN)

/* Used to assign mag_ids to lag_id holders */
struct lf_lag_id_def {
  unsigned char ld_lag_id[LF_LAG_ID_LEN];
  int ld_ref_cnt;
  int ld_mag_id;
  int ld_lag_index;

  struct lf_lag_id_def *ld_hash_next;	/* same hash value */
};

/*
 * prototypes
 */
int lf_lag_assign_mag_ids(struct lf_fabric *);
char *lf_lag_id_string(unsigned char *lag_id);

/*
 * inlines
 */
static inline int
lf_lag_hash(
  unsigned char *lag_id)
{
  int i;
  int hash;

  hash = *lag_id++;
  for (i=1; i<LF_LAG_ID_LEN; ++i) {
    hash ^= *lag_id++;
  }
  return hash;
}

#endif /* _lf_lag_h */
